

<?php $__env->startSection('main'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><i class="fas fa-shopping-cart"></i> Sales Management</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Sales</li>
                    </ol>
                </div>
            </div>
        </div>
        
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fas fa-exclamation-circle"></i> <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>
    </section>

    <!-- Sales Summary Cards -->
    <section class="content">
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="small-box bg-info">
                    <div class="inner">
                        <h3 id="total-sales"><?php echo e(count($sales)); ?></h3>
                        <p>Total Sales</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-success">
                    <div class="inner">
                        <h3 id="total-amount"><?php echo e($all_settings->currency ?? 'BDT'); ?> <?php echo e(number_format($totals['total_amount'], 2)); ?></h3>
                        <p>Total Amount</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-dollar-sign"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-warning">
                    <div class="inner">
                        <h3 id="total-profit"><?php echo e($all_settings->currency ?? 'BDT'); ?> <?php echo e(number_format($totals['total_profit'], 2)); ?></h3>
                        <p>Total Profit</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="small-box bg-danger">
                    <div class="inner">
                        <h3 id="total-quantity"><?php echo e($totals['total_sale']); ?></h3>
                        <p>Items Sold</p>
                    </div>
                    <div class="icon">
                        <i class="fas fa-box"></i>
                    </div>
                </div>
            </div>
        </div>

        <?php if (isset($component)) { $__componentOriginal1f678895c2a12b0f4f8cf09d654bc82d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1f678895c2a12b0f4f8cf09d654bc82d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin-table','data' => ['title' => 'All Sales Transactions','ajaxUrl' => route('sale.index'),'tableId' => 'sales-table','showSearch' => true,'showDateFilter' => true,'showExport' => true,'columns' => [
                ['title' => 'SL', 'field' => 'sl', 'orderable' => false],
                ['title' => 'Product', 'field' => 'product_name'],
                ['title' => 'Customer', 'field' => 'customer_name'],
                ['title' => 'Type', 'field' => 'type'],
                ['title' => 'Payment Method', 'field' => 'payment_method'],
                ['title' => 'Unit Price', 'field' => 'sell_price'],
                ['title' => 'Quantity', 'field' => 'sold_quantity'],
                ['title' => 'Total Price', 'field' => 'total_price'],
                ['title' => 'Profit', 'field' => 'profit'],
                ['title' => 'Warranty', 'field' => 'warranty'],
                ['title' => 'Sale Date', 'field' => 'sale_date'],
                ['title' => 'Actions', 'field' => 'actions', 'orderable' => false, 'searchable' => false]
            ]]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'All Sales Transactions','ajax-url' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('sale.index')),'table-id' => 'sales-table','show-search' => true,'show-date-filter' => true,'show-export' => true,'columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute([
                ['title' => 'SL', 'field' => 'sl', 'orderable' => false],
                ['title' => 'Product', 'field' => 'product_name'],
                ['title' => 'Customer', 'field' => 'customer_name'],
                ['title' => 'Type', 'field' => 'type'],
                ['title' => 'Payment Method', 'field' => 'payment_method'],
                ['title' => 'Unit Price', 'field' => 'sell_price'],
                ['title' => 'Quantity', 'field' => 'sold_quantity'],
                ['title' => 'Total Price', 'field' => 'total_price'],
                ['title' => 'Profit', 'field' => 'profit'],
                ['title' => 'Warranty', 'field' => 'warranty'],
                ['title' => 'Sale Date', 'field' => 'sale_date'],
                ['title' => 'Actions', 'field' => 'actions', 'orderable' => false, 'searchable' => false]
            ])]); ?>
             <?php $__env->slot('extraFilters', null, []); ?> 
                <div class="col-md-2">
                    <label for="type_filter" class="form-label">Type</label>
                    <select class="form-control" id="type_filter" name="type_filter">
                        <option value="">All Types</option>
                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type); ?>"><?php echo e(ucfirst($type)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                
                <div class="col-md-2">
                    <label for="payment_filter" class="form-label">Payment Method</label>
                    <select class="form-control" id="payment_filter" name="payment_filter">
                        <option value="">All Methods</option>
                        <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($method); ?>"><?php echo e(ucfirst($method)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
             <?php $__env->endSlot(); ?>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1f678895c2a12b0f4f8cf09d654bc82d)): ?>
<?php $attributes = $__attributesOriginal1f678895c2a12b0f4f8cf09d654bc82d; ?>
<?php unset($__attributesOriginal1f678895c2a12b0f4f8cf09d654bc82d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1f678895c2a12b0f4f8cf09d654bc82d)): ?>
<?php $component = $__componentOriginal1f678895c2a12b0f4f8cf09d654bc82d; ?>
<?php unset($__componentOriginal1f678895c2a12b0f4f8cf09d654bc82d); ?>
<?php endif; ?>
    </section>

    <?php $__env->startPush('script'); ?>
    <script>
        // Update summary cards when table data changes
        $(document).on('xhr.dt', '#sales-table', function(e, settings, json) {
            if (json && json.totals) {
                $('#total-sales').text(json.recordsFiltered || 0);
                $('#total-amount').text('<?php echo e($all_settings->currency ?? 'BDT'); ?> ' + (json.totals.total_amount || 0).toFixed(2));
                $('#total-profit').text('<?php echo e($all_settings->currency ?? 'BDT'); ?> ' + (json.totals.total_profit || 0).toFixed(2));
                $('#total-quantity').text(json.totals.total_quantity || 0);
            }
        });
    </script>
    <?php $__env->stopPush(); ?>
    <section class="content">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-5">
                        <form method="GET" class="">
                            <label>Select Date Range:</label>
                            <input type="text" name="date_range" id="date_range" class="form-control d-inline w-50"
                                value="<?php echo e(request('date_range')); ?>">
                            <button type="submit" class="btn btn-primary ml-2">Filter</button>
                        </form>
                    </div>
                </div>
                <?php
                    $line_total_amount = 0;
                    $total_amount = 0;
                    $total_profit = 0;
                    $line_total_profit = 0;
                ?>
                <table id="data_table" class="table table-bordered table-striped">
                    <thead>
                        <th>#</th>
                        <th>Customer Name</th>
                        <th>Brand/Tpye</th>
                        <th>Model/Name</th>
                        <th>IMEI/SN</th>
                        <th>Selling Price</th>
                        <th>Quantity</th>
                        <th>Total Amount</th>
                        <th>Profit</th>
                        <th>Sale Date</th>
                        <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $sales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $line_total_amount = $sale->sell_price * $sale->sold_quantity;
                                $line_total_profit = $sale->profit;
                                $total_amount += $line_total_amount;
                                $total_profit += $line_total_profit;
                            ?>
                            <tr>
                                <td><?php echo e($sale->id); ?></td>
                                <td><?php echo e(htmlspecialchars($sale->customer_name)); ?></td>
                                <td><?php echo e(e($sale->product->brand)); ?>  <?php echo e(e($sale->product->type)); ?></td>
                                <td><?php echo e(e($sale->product->model)); ?>  <?php echo e(e($sale->product->name)); ?></td>
                                <td><?php echo e(htmlspecialchars($sale->product->imei_or_sn)); ?></td>
                                <td><?php echo e($all_settings->currency . ' ' . number_format($sale->sell_price, 2)); ?></td>
                                <td><?php echo e($sale->sold_quantity); ?></td>
                                <td><?php echo e($all_settings->currency . ' ' . number_format($line_total_amount, 2)); ?>

                                </td>
                                <td><?php echo e($all_settings->currency . ' ' . number_format($line_total_profit, 2)); ?></td>
                                <td><?php echo e($sale->created_at); ?></td>
                                <td>
                                    <div class="btn-group">
                                        <button type="button" class="btn btn-danger dropdown-toggle" data-toggle="dropdown"
                                            aria-haspopup="true" aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="dropdown-menu">
                                            
                                            <a class="dropdown-item" href="<?php echo e(route('sale.invoice', $sale->id)); ?>">Print
                                                Invoice</a>
                                            <form action="<?php echo e(route('sale.destroy', $sale->id)); ?>" method="POST"
                                                onsubmit="return confirm('Are you sure you want to delete this sale?')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="dropdown-item text-danger">Delete</button>
                                            </form>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>#</th>
                            <th>Customer Name</th>
                            <th>Brand</th>
                            <th>Model</th>
                            <th>IMEI/SN</th>
                            <th>Selling Price</th>
                            <th>Quantity</th>
                            <th>Total Amount</th>
                            <th>Profit</th>
                            <th>Sale Date</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
                <table id="summary_table" class="table table-bordered table-striped mt-3">
                    <thead>
                        <tr>
                            <th>Total Sale</th>
                            <th>Total Amount</th>
                            <th>Total Profit</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td id="total_sales"><?php echo e(count($sales)); ?></td>
                            <td id="total_sell_amount"><?php echo e($all_settings->currency); ?>

                                <?php echo e(number_format($total_amount, 3)); ?>

                            </td>
                            <td id="total_profit"><?php echo e($all_settings->currency); ?> <?php echo e(number_format($total_profit, 3)); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(function() {
            $("#data_table").DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": false,
                "lengthMenu": [
                    [10, 50, 100, 500, -1],
                    [10, 50, 100, 500, "All"]
                ],
                "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });
        $(document).ready(function() {

            $('#date_range').daterangepicker({
                autoUpdateInput: false,
                locale: {
                    format: 'YYYY-MM-DD'
                }
            }).on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY-MM-DD') + ' - ' + picker.endDate.format(
                    'YYYY-MM-DD'));
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/pos24.3/resources/views/sell/index.blade.php ENDPATH**/ ?>